function [ok]=udp_bit_set(skt,name,data)
%function [ok]=udp_bit_set(skt,name,data)
% High level function for setting variables on PIC over udp
% calls udp_bit_set_poke to do its work
% udpset and udpget are the functions expected to be used normally
% updated for octave 4-Feb-2018 - Ian Stothers
% bit set/clear added 8-July-2020 - Ian Stothers
hidx=find(skt.hash==sum(name+0));

if (max(size(hidx))>0)
 idx=findname(skt.name,name,hidx);
 if (min(size(idx)<1))
   error('Name not found');
 end
 sda=size(data);
 data=reshape(data,1,sda(1)*sda(2));
 b=uint8(udpputconv(data,skt.type(idx)));
 msb=max(size(b));
 if (isfield(skt,'ser')==1)
  ser_bit_set(skt,skt.ptr(idx),b(1:min(msb,skt.len(idx))));
 else
  b=udp_bit_set_poke(skt,skt.ptr(idx),b(1:min(msb,skt.len(idx))));
 end
 ok=1;
else
   ok=0;
end
endfunction

function [ok]=udp_bit_set_poke(skt,add,data)
%function [ok]=udp_bit_set_poke(add,data,skt)
% Low level function for pokeing bytes to PIC over udp
% wrapper for udppokeb
% updated for octave 4-Feb-2018 - Ian Stothers
% bit set/clear added 8-July-2020 - Ian Stothers
len=max(size(data));
dptr=1;
   while (len>0)
      put=min([len skt.max]);
      udp_bit_set_pokeb(skt,add,data(dptr:(dptr+put-1)));
      len=len-put;
      add=add+put;
      dptr=dptr+put;
   end
   ok=1;

endfunction

function [ok]=udp_bit_set_pokeb(skt,add,data)
%function [ok]=udppokeb(skt,add,data)
% Low level function for pokeing bytes to PIC over udp
% updated for octave 4-Feb-2018 - Ian Stothers
% updated for compatibility with 32 bit mcu octave 25/may/2020 - Ian Stothers
% bit set/clear added 8-July-2020 - Ian Stothers
% updated for new instrument control api octave 28 Mar 2022- Ian Stothers
if (skt.bits==16)
  [ok]=udppokeb16(skt,add,len);
  return;
end
sda=size(data);
sda=sda(1)*sda(2);
data=reshape(data,1,sda);
 pbuf=uint8([7 1 0 0 bitand(sda,255) bitand(floor(sda/2.^8),255) bitand(floor(sda/2.^16),255) bitand(floor(sda/2.^24),255)...
      bitand(add,255) bitand(floor(add/2.^8),255) bitand(floor(add/2.^16),255) bitand(floor(add/2.^24),255) bitand(data,255)]);

retry=10;
ok=0;
b=[];
rx_timeout=0.002;

config_write('O',add,data);
while (retry>0)

  flushinput(skt.udp);
  write(skt.udp,pbuf,skt.ip,skt.port);
  flushoutput(skt.udp);
  pause(rx_timeout);
  b=read(skt.udp,8);
  if (max(size(b))>=4)
   if((b(1)==8)&(b(2)==1)&(b(3)==0)&(b(4)==0))
    ok=1;
    retry=0;
   end
  end
   retry=retry-1;
 end
endfunction


function [ok]=ser_bit_set(skt,add,data)
%function [ok]=ser_bit_set(skt,add,data)
% Low level function for setting bits in stm over serial
%
% 10-June- 2023 - Ian Stothers

pp_commands;
ok=1;
op=[];
 len=prod(size(data));
 dptr=0;

 data=bitand(data(:)',255);
 while (len>0)
      toget=min([len skt.max]);
      pbuf=uint8([UDP_BIT_SET bitand(toget,255)]);
      pbuf=[pbuf  bitand(add,255) bitand(floor(add/2.^8),255) bitand(floor(add/2.^16),255) bitand(floor(add/2.^24),255)];
      pbuf=[pbuf  data((1:toget)+dptr)];
      bb=sersendget(skt,pbuf,PPHSIZE);
      if (max(size(bb))==PPHSIZE)
        if ((bb(1:4)==[UDP_BIT_SET_REPLY])&&(toget==bb(5)))
           dptr=dptr+toget;
           len=len-toget;
           add=add+toget;
        end
      end
 end %while len
endfunction


